//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Runtime.InteropServices;

namespace Bench
{
	/// <summary>
	/// Podsumowanie dla UnmanagedTcpTest.
	/// </summary>
	class UnmanagedNetworking
	{
		[DllImport("UnmanagedNetworking.dll")]
		public static extern void SynchTcpTest(string server, int port, int nPackets, int packetSize);
		[DllImport("UnmanagedNetworking.dll")]
		public static extern void SynchUdpTest(string server, int port, int nPackets, int packetSize);
		[DllImport("UnmanagedNetworking.dll")]
		public static extern int Start();
		[DllImport("UnmanagedNetworking.dll")]
		public static extern int TransmitByteCount();
		[DllImport("UnmanagedNetworking.dll")]
		public static extern int ReceivedByteCount();
		[DllImport("UnmanagedNetworking.dll")]
		public static extern double Elapsed();
		[DllImport("UnmanagedNetworking.dll")]
		public static extern void Stop();
	}

	public class UnmanagedTcpTest : NetworkTest
	{
		public UnmanagedTcpTest(string server, int port, int numberOfPackets, int packetSize) :
			base(server, port, numberOfPackets, packetSize)
		{
			UnmanagedNetworking.SynchTcpTest(Server, Port, NumberOfPackets, PacketSize);
		}
		public override void Start()
		{
			// Wykonanie testu
			StartCounters();
			int startTime = Environment.TickCount;
			
			UnmanagedNetworking.Start();

			int endTime = Environment.TickCount;
			StopCounters();

			TransmitByteCount = UnmanagedNetworking.TransmitByteCount();
			ReceivedByteCount = UnmanagedNetworking.ReceivedByteCount();
			Elapsed = (float)UnmanagedNetworking.Elapsed();

			UnmanagedNetworking.Stop();
		}
	}
}
